/*
| IBIC Simulation Tool
| Copyright (C) 2012-2013 Jacopo Forneris
| http://www.dfs.unito.it/solid/IST.html

This file is part of IBIC simulation tool.

    IBIC simulation tool is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    IBIC simulation tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with IBIC Simulation Tool.  If not, see <http://www.gnu.org/licenses/>.
*/


#include <QThread>
#include "mainwindow.h"
#include <QVector>

#ifndef MYLIBRARYWRAPPER_H
#define MYLIBRARYWRAPPER_H

class MyLibraryWrapper : public QThread
{
Q_OBJECT



public:

    //define thread
    MyLibraryWrapper();

    //duplicate from mainwindow
    QString path_gunn, path_efield, path_vac, path_ioniz;
    QString title_plot;

    int L;
    double deltax, deltatn, deltatp;
    double temp,ndiff, pdiff, vsatp, vsatn, taup, taun, mun, mup;
    QVector<double> pos_gunn, gunn;
    QVector<double> pos_efield, efield;
    QVector<double> pdrift, ndrift, mp, mn;
    QVector<double> taup_arr, taun_arr, ptaup, ptaun;

    int n_point, n_ion, n_eh, steps;
    double dispersion, e_noise, e_threshold;
    // double ntherm, ptherm, radhard, nsigma, psigma, fluence;
    double dead_layer;
    QVector<double> x_vac, y_vac, x_ioniz, y_ioniz;
    QVector<double> yvac_inter, yioniz_inter, CDF_ion;

    int ion, p, x0;
    double progress, end_sim;
    double tot_mean_plot, tot_hit_over;
    double aux_mean_frontal, cce_mean_frontal;
    int hit_frontal; // cisti era un double!
    QVector<double> cce_mean, cce_mean_plot, gen_pos;
    QVector<int> hit_over_threshold;

    int lat_front;
    int control_vac, control_ion;
    double maxtscale, valtscale;
    int gnearest;
    double slide_generation_point, gpoint;
    QVector<double> xgpoint, ygpoint;
    QVector<int> maximum;
    QVector<double> x_histo_mean, y_histo_mean;
    QVector<QVector<double> > multipos;



    int num_t_plot;
    QVector<double> cce_frontal_ion_p, cce_frontal_ion_n, cce_tfrontal_aux, cce_tfrontal;
    QVector<QVector<double> > cce_frontal_ion_p2, cce_frontal_ion_n2, cce_tfrontal_aux2, cce_tfrontal2;
    QVector<double>  cce_time_frontal_tot;
    QVector<int> cce_time_frontal_p, cce_time_frontal_n;

    QVector<double> histo_step;
    QVector<QVector<double > > tot_spectrum;

    QVector<double> cce;
    QVector<double> cce_noise;
    QVector<QVector<double> > cce_threshold;
    QVector<double> cce_frontal, cce_frontal_thresh;
    QVector<double> cce_median;


    //removable?
    QVector<QVector<double> >  cce_time_frontal_tot2;
    QVector<QVector<int> > cce_time_frontal_p2, cce_time_frontal_n2;



    //initialize thread evaluation variables
    QTimer dataTimer;
    int thread_status;
    int prog_show;

private:



protected:

   void run();
signals:
   void done(const QString &results);
   int updateProgressbar(int value);
   void passValues(/*QVector<double> value1, QVector<QVector<double> > value2, double value3, QVector<QVector<double> > value4, QVector<QVector<double > > value5,
                   QVector<double> value6,QVector<double> value7,QVector<double> value8,double value9,double value10,QVector<int> value11,QVector<double> value12,QVector<QVector<double> > value13*/);
   void thread_finished();
   void delete_thread();

public slots:

      void stop_thread();
      void launch();

      void start_thread();
      //void execute();

private slots:
   void doTheWork();
   void montecarlo();
   void frontal();

};

#endif // MYLIBRARYWRAPPER_H
