/*
| IBIC Simulation Tool
| Copyright (C) 2012-2013 Jacopo Forneris
| http://www.dfs.unito.it/solid/IST.html

This file is part of IBIC simulation tool.

    IBIC simulation tool is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    IBIC simulation tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with IBIC Simulation Tool.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "dialog_setup.h"
#include "ui_dialog_setup.h"
#include <QDebug>
#include <fstream>
#include <stdio.h>
#include <sys/time.h>
#include <iomanip>
#include <sstream>
#include <string>
#include <QString.h>
#include <iostream>
#include <stdlib.h>
#include <qfile.h>
#include <qtextstream.h>
#include <QTextBrowser>
#include <QDir>


Dialog_setup::Dialog_setup(QWidget *parent) :
  QDialog(parent),
  ui(new Ui::Dialog_setup)
{
  ui->setupUi(this);

  MainWindow *obj = (MainWindow *) qApp->activeWindow();

  //initialize window
  //print values stored from previous usage of the dialog
  length=obj->L;
  deltax=obj->deltax;
 if(!obj->path_ioniz.isEmpty())
  {
     // path_ioniz=obj->last_path_ioniz;


  path_ioniz=obj->path_ioniz;


  ui->lineEdit_ionpath->setText(path_ioniz);
  QFile file_ioniz(path_ioniz);
  QTextStream its_ioniz(&file_ioniz);
  QString line_ioniz;

  //if file doesn't exist, set control variable to 1
  if (!file_ioniz.open(QIODevice::ReadOnly))
  {
       control_ion=1;
  }
  else
  {
      control_ion=0;
  }

  //read SRIM ionization data to file
  x_ioniz.resize(100);
  y_ioniz.resize(100);

  //import file if path is correct
  if(control_ion==0)
  {
      int l=0;

      //check data format and split columns
      while(!its_ioniz.atEnd())
      {
          line_ioniz = its_ioniz.readLine();
          line_ioniz.replace(",",".");
          line_ioniz.replace("\t", "   ");
          QStringList list_ioniz=line_ioniz.split(" ",QString::SkipEmptyParts);

          //if at least two columns, check for numerical data and store to local arrays
          if(list_ioniz.size()>1)
          {
              bool validate1, validate2;
              list_ioniz.first().toDouble(&validate1);
              list_ioniz[1].toDouble(&validate2);
              if (validate1 == true && validate2 ==true && list_ioniz.size()>1)
              {
                  x_ioniz[l]=list_ioniz.first().toDouble()*1e-4;//   [ um ]
                  y_ioniz[l]=list_ioniz[1].toDouble()*1e10;     //   [ eV/m]
                  l++;
              }
          }
      }
  file_ioniz.close();
  }
  //if file doesn't exist, fill vector with 0's
  else
  {
      for(int l=0; l<100; l++)
      {
          x_ioniz[l]=0;
          y_ioniz[l]=0;
          control_ion=0;
      }
  }

  //Plot ionization profile in dialog window
  setupIoniz(ui->ioniz_plot);
  ui->ioniz_plot->replot();

 }



  lat_front=obj->lat_front;
  n_point = obj->n_point;
  n_ion = obj->n_ion;
  n_eh = obj->n_eh;
  dispersion = obj->dispersion*1e6;    //  [ um ]
  e_noise= obj->e_noise*100;           //  [ % ]


  //define control variable for data storage
  control_ion=-1;

  e_threshold= obj->e_threshold*100;   //  [ % ]
  dead_layer=obj->dead_layer;          //  [ um ]

  //variable lat_front defines frontal (if ==1) or lateral (if == 0) IBIC geometry
  if(lat_front==0)
  {
      ui->radioButton->setChecked(false);
      ui->radioButton_2->setChecked(true);
      ui->lineEdit_ionpath->setDisabled(true);
      ui->pushButton_browseion->setDisabled(true);
      ui->lineEdit_deadlayer->setDisabled(true);
  }
  else
  {
      ui->radioButton->setChecked(true);
      ui->radioButton_2->setChecked(false);
      ui->lineEdit_npoints->setDisabled(true);
      ui->lineEdit_dispersion->setDisabled(true);

      //display ionization profile plot
      setup_frontal_plot_first();
  }

  //general data initialization and setud
  ui->lineEdit_npoints->setText(QString::number(n_point));
  ui->lineEdit_nions->setText(QString::number(n_ion));
  ui->lineEdit_npairs->setText(QString::number(n_eh));
  ui->lineEdit_dispersion->setText(QString::number(dispersion));
  ui->lineEdit_noise->setText(QString::number(e_noise));
  ui->lineEdit_threshold->setText(QString::number(e_threshold));
  ui->lineEdit_deadlayer->setText(QString::number(dead_layer));

  //setup the update function when text lines are edited
  connect(ui->lineEdit_nions,SIGNAL(editingFinished()),this,SLOT(update_values()));
  connect(ui->lineEdit_npairs,SIGNAL(editingFinished()),this,SLOT(update_values()));
  connect(ui->lineEdit_npoints,SIGNAL(editingFinished()),this,SLOT(update_values()));
  connect(ui->lineEdit_dispersion,SIGNAL(editingFinished()),this,SLOT(update_values()));
  connect(ui->lineEdit_threshold,SIGNAL(editingFinished()),this,SLOT(update_values()));
  connect(ui->lineEdit_noise,SIGNAL(editingFinished()),this,SLOT(update_values()));
  connect(ui->lineEdit_deadlayer,SIGNAL(editingFinished()),this,SLOT(update_values()));
}


Dialog_setup::~Dialog_setup()
{
    delete ui;
    //clear control variable when window is closed
    simok=0;
}


void Dialog_setup::on_pushButton_cancel_clicked()
{
    //if cancel button clicked, control variable for main window is set to 1
    simok=1;
}


void Dialog_setup::on_radioButton_2_clicked()
{
    //select editable values for lateral IBIC simulation
    ui->lineEdit_ionpath->setDisabled(true);
    ui->pushButton_browseion->setDisabled(true);
    ui->lineEdit_deadlayer->setDisabled(true);
    ui->ioniz_plot->setVisible(false);
    ui->lineEdit_ionpath->setText("");
    lat_front=0;
    ui->lineEdit_npoints->setEnabled(true);
    ui->lineEdit_dispersion->setEnabled(true);
    control_ion=-1;
}

void Dialog_setup::on_radioButton_clicked()
{
    //select editable values/fields for frontal IBIC simulation
    ui->lineEdit_ionpath->setEnabled(true);
    ui->pushButton_browseion->setEnabled(true);
    ui->lineEdit_deadlayer->setEnabled(true);
    ui->ioniz_plot->setVisible(true);
    ui->lineEdit_ionpath->setText(path_ioniz);
    lat_front=1;
    ui->lineEdit_npoints->setText("1");
    ui->lineEdit_npoints->setDisabled(true);
    ui->lineEdit_dispersion->setText("0");
    ui->lineEdit_dispersion->setDisabled(true);

    //display ionization profile plot
    setup_frontal_plot_first();
}


void Dialog_setup::on_pushButton_browseion_clicked()
{
    //open file browser to import SRIM ionization profile
    FileBrowser browser;
    browser.exec();
    path_ioniz=browser.on_buttonBox_accepted();
    control_ion=0;

    //store file path and open file for data import
    ui->lineEdit_ionpath->setText(path_ioniz);
    QFile file_ioniz(path_ioniz);
    QTextStream its_ioniz(&file_ioniz);
    QString line_ioniz;

    //if file doesn't exist, set control variable to 1
    if (!file_ioniz.open(QIODevice::ReadOnly))
    {
         control_ion=1;
    }
    else
    {
        control_ion=0;
    }

    //read SRIM ionization data to file
    x_ioniz.resize(100);
    y_ioniz.resize(100);

    //import file if path is correct
    if(control_ion==0)
    {
        int l=0;

        //check data format and split columns
        while(!its_ioniz.atEnd())
        {
            line_ioniz = its_ioniz.readLine();
            line_ioniz.replace(",",".");
            line_ioniz.replace("\t", "   ");
            QStringList list_ioniz=line_ioniz.split(" ",QString::SkipEmptyParts);

            //if at least two columns, check for numerical data and store to local arrays
            if(list_ioniz.size()>1)
            {
                bool validate1, validate2;
                list_ioniz.first().toDouble(&validate1);
                list_ioniz[1].toDouble(&validate2);
                if (validate1 == true && validate2 ==true && list_ioniz.size()>1)
                {
                    x_ioniz[l]=list_ioniz.first().toDouble()*1e-4;//   [ um ]
                    y_ioniz[l]=list_ioniz[1].toDouble()*1e10;     //   [ eV/m]
                    l++;
                }
            }
        }
    file_ioniz.close();
    }
    //if file doesn't exist, fill vector with 0's
    else
    {
        for(int l=0; l<100; l++)
        {
            x_ioniz[l]=0;
            y_ioniz[l]=0;
            control_ion=0;
        }
    }

    //Plot ionization profile in dialog window
    setupIoniz(ui->ioniz_plot);
    ui->ioniz_plot->replot();
}


void Dialog_setup::setupIoniz(QCustomPlot *potPlot)
{
    //setup graph layer, line color, curve fill brush
    potPlot->addGraph(); // blue line
    potPlot->graph(0)->setBrush(QBrush(QColor(128, 128, 128)));
    potPlot->graph(0)->setAntialiasedFill(false);
    potPlot->graph(0)->setPen(QPen(Qt::blue));

    //setup axes visualization
    potPlot->xAxis->setVisible(true);
    potPlot->xAxis2->setVisible(false);
    potPlot->xAxis2->setTickLabels(true);
    potPlot->yAxis2->setVisible(true);
    potPlot->yAxis2->setTickLabels(false);

    //setup ionization plot data
    potPlot->graph(0)->setData(x_ioniz, y_ioniz);

    // setup axes labels, range, number of axis ticks
    potPlot->xAxis->setLabel("Position (um)");
    potPlot->yAxis->setLabel("Ionization (eV/cm)");
    potPlot->graph(0)->rescaleAxes(true);
    potPlot->xAxis->setRange(0.0,x_ioniz.last());
    potPlot->yAxis->setAutoTickCount(5);
    potPlot->xAxis->setAutoTickCount(5);
}

void Dialog_setup::update_values()
{
    //when function is called, store to local memory values displayed in the fields
    //values to be passed to the main program by "OK" button
    n_point = ui->lineEdit_npoints->text().toInt();
    n_ion = ui->lineEdit_nions-> text().toInt();
    n_eh = ui->lineEdit_npairs-> text().toInt();
    dispersion = ui->lineEdit_dispersion-> text().toDouble();
    e_noise = ui->lineEdit_noise-> text().toDouble();
    e_threshold = ui->lineEdit_threshold-> text().toDouble();
    dead_layer=ui->lineEdit_deadlayer->text().toDouble();

    //if frontal IBIC mode, display ionization profilep plot, if any
    if(lat_front==1 && control_ion==0)
    {
        setup_frontal_plot_first();
        setupIoniz(ui->ioniz_plot);
        ui->ioniz_plot->replot();
    }

    //check setup status to set control variable
    //number of points, number of ions per point, number of e-h pairs per ion should
    //be greater than zero to successfully achieve the setup - to enable "OK" button
    if(n_point>0 && n_ion >0 && n_eh >0 && control_ion<1)
    {
    simok=0;
    ui->pushButton_2->setEnabled(true);
    }
    else
    {
    ui->pushButton_2->setDisabled(true);
    simok=1;
    }
}


void Dialog_setup::setup_frontal_plot_first(){

    control_ion=0;
    ui->lineEdit_ionpath->setText(path_ioniz);
    QFile file_ioniz(path_ioniz);
    QTextStream its_ioniz(&file_ioniz);
    QString line_ioniz;
    if (!file_ioniz.open(QIODevice::ReadOnly))
        {
         control_ion=1;
        }
    else
    {
        control_ion=0;
    }

    QVector<double> x_ion_import;
    x_ion_import.resize(0);
    x_ioniz.resize(0);
    y_ioniz.resize(0);

    if(control_ion==0)
    {
        int l=0;

        while(!its_ioniz.atEnd())
        {
        line_ioniz = its_ioniz.readLine();
        line_ioniz.replace(",",".");
        line_ioniz.replace("\t", "   ");


        QStringList list_ioniz=line_ioniz.split(" ",QString::SkipEmptyParts);

        if(list_ioniz.size()>1)
        {
        bool validate1, validate2;

        list_ioniz.first().toDouble(&validate1);
        list_ioniz[1].toDouble(&validate2);


        if (validate1 == true && validate2 ==true && list_ioniz.size()>1)
        {

        x_ion_import.push_back(list_ioniz.first().toDouble()*1e-4);  //inserito già in micrometri
        x_ioniz.push_back(x_ion_import[l]-dead_layer);
        y_ioniz.push_back(list_ioniz[1].toDouble()*1e10);            //udm: vac/m
        l++;


        }
        }
    }
    file_ioniz.close();
    }
    else
    {
        for(int l=0; l<100; l++)
        {
            x_ioniz.push_back(l);
            y_ioniz.push_back(0);
            control_ion=0;
        }
    }
    setupIoniz(ui->ioniz_plot);
    ui->ioniz_plot->replot();
}
