/*
| IBIC Simulation Tool
| Copyright (C) 2012-2013 Jacopo Forneris
| http://www.dfs.unito.it/solid/IST.html

This file is part of IBIC simulation tool.

    IBIC simulation tool is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    IBIC simulation tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with IBIC Simulation Tool.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef DIALOG_SETUP_H
#define DIALOG_SETUP_H

#include <QDialog>
#include "mainwindow.h"
#include "./qcustomplot.h"

namespace Ui {
  class Dialog_setup;
}

class Dialog_setup : public QDialog
{
  Q_OBJECT
  
public:
  explicit Dialog_setup(QWidget *parent = 0);
  ~Dialog_setup();

QString path_ioniz;

  int n_point,n_ion, n_eh, srim, simok, lat_front, length, control_ion;
  double dispersion, e_noise, e_threshold, deltax, dead_layer;
  QVector<double> x_ioniz, y_ioniz;

private slots:

  void on_radioButton_2_clicked();
  void on_radioButton_clicked();
  void on_pushButton_browseion_clicked();
  void setupIoniz(QCustomPlot *potPlot);
  void update_values();
  void on_pushButton_cancel_clicked();
  void setup_frontal_plot_first();

private:
  Ui::Dialog_setup *ui;
};

#endif // DIALOG_SETUP_H










