/*
| IBIC Simulation Tool
| Copyright (C) 2012-2013 Jacopo Forneris
| http://www.dfs.unito.it/solid/IST.html

This file is part of IBIC simulation tool.

    IBIC simulation tool is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    IBIC simulation tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with IBIC Simulation Tool.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef FILESDIALOG_H
#define FILESDIALOG_H

#include <QDialog>
#include "filebrowser.h"
#include "./qcustomplot.h"


namespace Ui {
    class FilesDialog;
}

class FilesDialog : public QDialog
{
    Q_OBJECT

public:
    explicit FilesDialog(QWidget *parent = 0);
    ~FilesDialog();

//define path string for input files
QString path_gunn, path_efield;

//define variables for charge transport properties
double temp, mun, mup, vsatp, vsatn, taup, taun;

//define variables for device geometry
double deltax, space_step_gunn, space_step_efield;
int L;

//define vectors for input files import
QVector<double> gunn, pos_gunn, efield, pos_efield;

//define control variables
int checkdialog; //check everything is consistent before ok
int efilenotfound, gfilenotfound;   //check whether input files do exist


private:
    Ui::FilesDialog *ui;

private slots:

    void on_pushButton_gunn_clicked();      //open file browser
    void on_pushButton_efield_clicked();
    void plotEfield();                      //import file and plot
    void plotGunn();
    void setupGunn(QCustomPlot *potPlot);   //plot setup and configuration
    void setupEfield(QCustomPlot *potPlot);
    void on_pushButton_OK_clicked();        //accept and close dialog
    void on_pushButton_cancel_clicked();
    void update_values();                   //automatically store input values from user
    void text_efield();                     //display of import file status and info
    void text_gunn();
};

#endif // FILESDIALOG_H
