/*
| IBIC Simulation Tool
| Copyright (C) 2012-2013 Jacopo Forneris
| http://www.dfs.unito.it/solid/IST.html

This file is part of IBIC simulation tool.

    IBIC simulation tool is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    IBIC simulation tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with IBIC Simulation Tool.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "filesdialog.h"
#include "dialog_setup.h"
#include "dialog_import.h"
#include "wizard.h"
#include "./qcustomplot.h"
#include <QTimer>
#include "dialog_import.h"
#include "radhard_dialog.h"
#include "licensedialog.h"


namespace Ui {
    class MainWindow;

}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();


//file paths and strings
QString path_gunn, path_efield, path_vac, path_ioniz; //strings to store input file location path
QString last_path_gunn, last_path_efield, last_path_vac, last_path_ioniz; //feature to remember last path: feature not implemented yet
QString title_plot; //string for plot title names

//device setup
int L;  //define device length
double deltax, deltatn, deltatp; //define space and time mesh step size
double temp, ndiff, pdiff, vsatp, vsatn, taup, taun, mun, mup; //define temperature, e-h diffusion length, saturation velocities, lifetimes, mobilities
QVector<double> pos_gunn, gunn; //define x, gunn(x) arrays
QVector<double> pos_efield, efield; //define x, efield(x) arrays
QVector<double> pdrift, ndrift, mp, mn; //define drift velocity and mobility arrays (determined from electric field)
QVector<double> taup_arr, taun_arr, ptaup, ptaun; //define lifetime arrays and recombination probabilities

//simulation setup
int n_point, n_ion, n_eh, steps; //number of simulation points, simulated ions, e-h pairs per ion, steps=L/npoints
double dispersion, e_noise, e_threshold; //values for beam dispersion, electronic noise and threshold
double ntherm, ptherm, radhard_p, radhard_n, nsigma, psigma, fluence; //values for radiation damage model
double dead_layer; // dead layer thickness in SRIM profiles, tunable by user
QVector<double> x_vac, y_vac, x_ioniz, y_ioniz; // fixed 100 arrays for SRIM import
QVector<double> yvac_inter, yioniz_inter, CDF_ion; //interpolation of vacancy, ionization, cumulative ioniztion distribution on array with length L

//simulation counters
int ion, p, x0; //simulated ion number, generation position, auxiliary generation position
double progress, end_sim; //simulation progress bar counter, end_sim=n_ion*ion_count
double tot_mean_plot, tot_hit_over; //numerator and denominator for mean evaluation (CCE over threshold)
double aux_mean_frontal, cce_mean_frontal;
int hit_frontal;  //numerator (aux_mean), denominator (hit-frontal) and result (cce_mean_frontal) for mean CCE evaluation over threshold in frontal mode
QVector<double> cce_mean, cce_mean_plot, gen_pos;
QVector<int> hit_over_threshold;

//control variables
int checkdialog; //control variable for correct filesdialog import window usage
int radiation_control; //1: do consider radiation damage model, 0: don't
int lat_front; //1: frontal ibic, 0: lateral ibic
int control_vac, control_ion; //check import of vcancy and ionization profiles
int set_legend; //show or hide legend on lateral ibic profile plot
int resume; //reads whether resume button is pressed to continue previous simulation

//visualization and plotting
double valtscale, maxtscale; //user defined value, and maximum available value for time scale plot
int tauplot_scale_x, tauplot_scale_y; //maximum values for lifetime plot setup (um,ns)
int gnearest; //counter, based on the number of steps for visualization of data on lateral IBIC profiles
double slide_generation_point, gpoint; // select generation position from slider and convert to array -> gnearest
QVector<double> xgpoint, ygpoint; // array for plotting blue line - to highlight selected generation position in lateral IBIC
QVector<int> maximum; //set maximum for spectra plot in lateral mode
QVector<double> x_histo_mean, y_histo_mean; //values to plot mean frontal CCE in spectra figures
QVector<QVector<double> > multipos; //abscissa for CCE over threshold scatters

//time-resolved calculation
int num_t_plot; //number of points per order of magnitude for time resolved CCE array
QVector<double> cce_frontal_ion_p, cce_frontal_ion_n, cce_tfrontal_aux, cce_tfrontal;//hole, electron time-resolved cumulative CCE values for frontal iBIC and average values (aux: sum e+p/e-h_number, tfrontal: aux/nions+1)
QVector<QVector<double> > cce_frontal_ion_p2, cce_frontal_ion_n2, cce_tfrontal_aux2, cce_tfrontal2; //same for lateral profiles
QVector<int> cce_time_frontal_p, cce_time_frontal_n; //auxiliary arrays to compare time iteration (aux integer variable) with time-resolved array values: when they match, print CCE to array
QVector<double>  cce_time_frontal_tot; //unified values of cce_time_frontal_p/n for printing/plotting (in ns)
QVector<QVector<int> > cce_time_frontal_p2, cce_time_frontal_n2; //same for lateral profiles

//spectra evaluation
QVector<double> histo_step; //abscissa binning of 110 CCE values between 0% and 110%
QVector<QVector<double> > tot_spectrum; //CCE counts per binning per generation position; [0] is for frontal ibic/total CCE

//cce evaluation and calculation
QVector<double> cce; //list of all CCE-without-postprocessing scatters
QVector<double> cce_noise; // list of all CCE-plus-noise scatters
QVector<QVector<double> > cce_threshold; //list of all CCE-over-threshold scatters (lateral IBIC)
QVector<double> cce_frontal, cce_frontal_thresh; //same for unprocessed/over-threshold frontal IBIC CCE pulses
QVector<double> cce_median; //median CCE profile as function of generation position







private:
    Ui::MainWindow *ui;

void slideChanged(int value);           //display spectra/time resolved plot associated with selected generation position
void legendClick();                     //display/hide legend on lateral ibic profile plot
void setupGunn(QCustomPlot *potPlot);   //setup weighting potential profile plot
void setupEfield(QCustomPlot *potPlot); //setup electric field profile plot
void setupIoniz(QCustomPlot *potPlot);  //setup ionization profile plot
void setupCDF(QCustomPlot *potPlot);    //setup cumulative distribution of ionization profile plot
void setupVac(QCustomPlot *potPlot);    //setup vacancy density profile plot
void setupTau(QCustomPlot *potPlot);    //setup lifetimes plot
void setupPdrift(QCustomPlot *potPlot); //setup e-drift velocity plot
void setupNdrift(QCustomPlot *potPlot); //setup h-drift velocity plot
void setupMC(QCustomPlot *potPlot, QCustomPlot *histo, QCustomPlot *time); //setup and launch monte carlo simulation kernel


QTimer dataTimer;

private slots:


    void wrapperDone();                 //terminate thread when finished
    void on_pushButton_simsetup_clicked();  //enter simulation setup menu
    void on_pushButton_sim_clicked();   //start simulation
    void electrostatics();              //defines and setup electrostatics
    void updatePlot();                  //update CCE plots during calculation
    void on_pushButton_resume_clicked();    //resume a stopped MC simulation
    void on_pushButton_stop_clicked();      //stop MC simulation
    void on_pushButton_saveplot_clicked();  //save MC simulation plots
    void on_checkBox_clicked();             //check to show legend
    void on_horizontalSlider_valueChanged(int value);   //slide to change generation position on lateral profile
    void on_time_spinBox_editingFinished(); //value changed on time-resolved scale
    void on_time_spinBox_valueChanged();//value changed on time-resolved scale
    void text_transport();              //display device setup information
    void text_simulation();             //display simulation setup information
    void text_radhard();                //display irradiation setup information
    void on_pushButton_radsetup_clicked();  //enter irradiation setup
    void on_pushButton_devsetup_clicked();  //enter device setup
    void on_pushButton_about_clicked();     //display About/License window
    void on_tau_x_valueChanged(int arg1);   //implement x axis change on lifetime plot
    void on_tau_y_valueChanged(int arg1);   //implement y axis change on lifetime plot
    void on_checkBox_2_stateChanged(int arg1);
};




#endif // MAINWINDOW_H



