/*
| IBIC Simulation Tool
| Copyright (C) 2012-2013 Jacopo Forneris
| http://www.dfs.unito.it/solid/IST.html

This file is part of IBIC simulation tool.

    IBIC simulation tool is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    IBIC simulation tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with IBIC Simulation Tool.  If not, see <http://www.gnu.org/licenses/>.
*/


#include "radhard_dialog.h"
#include "ui_radhard_dialog.h"

Radhard_dialog::Radhard_dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Radhard_dialog)
{
    ui->setupUi(this);

    MainWindow *obj = (MainWindow *) qApp->activeWindow();

    //in the following, variables initialization to values stored in mainwindow from previous user interactions
    radiation_control=obj->radiation_control;
    dead_layer=obj->dead_layer;

    //if radiation previously selected by user,check yes on radiobutton and enable editing. If not, check no and disable interaction
    if(radiation_control==0)
    {
        ui->lineEdit_fluence->setEnabled(false);
        ui->lineEdit_sigma_n->setEnabled(false);
        ui->lineEdit_sigma_p->setEnabled(false);
        ui->lineEdit_vac->setEnabled(false);
        ui->lineEdit_vth_n->setEnabled(false);
        ui->lineEdit_vth_p->setEnabled(false);
        ui->pushButton_vacBrowse->setEnabled(false);
        ui->doubleSpinBox_n->setEnabled(false);
        ui->doubleSpinBox_p->setEnabled(false);
        ui->radioButton_no->setChecked(true);
        ui->radioButton_yes->setChecked(false);
        path_vac=obj->path_vac;
        ui->lineEdit_vac->setText(path_vac);
        setup_vac_plot_first();
        ui->vac_plot->setVisible(false);
    }
    else if(radiation_control==1)
    {

        ui->lineEdit_fluence->setEnabled(true);
        ui->lineEdit_sigma_n->setEnabled(true);
        ui->lineEdit_sigma_p->setEnabled(true);
        ui->lineEdit_vac->setEnabled(true);
        ui->lineEdit_vth_n->setEnabled(true);
        ui->lineEdit_vth_p->setEnabled(true);
        ui->pushButton_vacBrowse->setEnabled(true);
        ui->doubleSpinBox_n->setEnabled(true);
        ui->doubleSpinBox_p->setEnabled(true);
        ui->radioButton_no->setChecked(false);
        ui->radioButton_yes->setChecked(true);

        path_vac=obj->path_vac;
        ui->lineEdit_vac->setText(path_vac);
        qDebug() << "copiato valori path_vac da mainwindow: ";
        qDebug() << path_vac;
        //call initial plot setup function
        plot_vac();
        qDebug()<< "effettuato il plot";
    }


    //initialize parameters from previous user iteractions
    fluence=obj->fluence*1e-4;       //cm-2 (in mainwindow is stored as m-2)
    sigmap=obj->psigma*1e4;          //cm2 (in mainwindow is stored as m-2)
    sigman=obj->nsigma*1e4;
    ptherm=obj->ptherm*100;          //cm/s (in mainwindow is stored as m/s)
    ntherm=obj->ntherm*100;
    radhard_p=obj->radhard_p;
    radhard_n=obj->radhard_n;



    //display values on window objects
    ui->lineEdit_fluence->setText(QString::number(fluence));
    ui->doubleSpinBox_n->setValue(radhard_n);
    ui->doubleSpinBox_p->setValue(radhard_p);
    ui->lineEdit_sigma_n->setText(QString::number(sigman));
    ui->lineEdit_sigma_p->setText(QString::number(sigmap));
    ui->lineEdit_vth_n->setText(QString::number(ntherm));
    ui->lineEdit_vth_p->setText(QString::number(ptherm));

    //automatized connection between user input/changes and values stored by update_values()
    connect(ui->lineEdit_fluence,SIGNAL(editingFinished()),this,SLOT(update_values()));
    connect(ui->lineEdit_sigma_n,SIGNAL(editingFinished()),this,SLOT(update_values()));
    connect(ui->lineEdit_sigma_p,SIGNAL(editingFinished()),this,SLOT(update_values()));
    connect(ui->lineEdit_vth_n,SIGNAL(editingFinished()),this,SLOT(update_values()));
    connect(ui->lineEdit_vth_p,SIGNAL(editingFinished()),this,SLOT(update_values()));
    connect(ui->doubleSpinBox_n,SIGNAL(valueChanged(double)),this,SLOT(update_values()));
    connect(ui->doubleSpinBox_p,SIGNAL(valueChanged(double)),this,SLOT(update_values()));


}


Radhard_dialog::~Radhard_dialog()
{
    delete ui;
}



void Radhard_dialog::plot_vac()
{
        x_vac.resize(100);
        y_vac.resize(100);

        //initialize control variable for input file
        control_vac=0;

        QFile file_vac(path_vac);
        QTextStream its_vac(&file_vac);
        QString line_vac;

        //change control variable if file doesn't exist
        if (!file_vac.open(QIODevice::ReadOnly))
        {
        control_vac=1;
        }

        //write input file contents to arrays
        if(control_vac==0)
        {
        int l=0;

        while(!its_vac.atEnd())
        {
        line_vac = its_vac.readLine();
        line_vac.replace(",",".");
        line_vac.replace("\t", "   ");
        QStringList list_vac=line_vac.split(" ",QString::SkipEmptyParts);

        //check for valid double format to skip header files and anomalous string lines
        if(list_vac.size()>0)
        {
        bool validate1, validate2;

        list_vac.first().toDouble(&validate1);
        list_vac.last().toDouble(&validate2);


        if (validate1 == true && validate2 ==true && list_vac.size()>1)
        {

            if(list_vac.first().toDouble()*1e-4-dead_layer>=0)
            {
            x_vac[l]=list_vac.first().toDouble()*1e-4-dead_layer;  //units: micrometers
            y_vac[l]=list_vac.last().toDouble()*1e10;              //units: vacancies/m
            l++;
            }
        }
        }
        }
    file_vac.close();

    //plot imported profile
    setupVac(ui->vac_plot);
    ui->vac_plot->replot();
        }
}


void Radhard_dialog::on_pushButton_vacBrowse_clicked()
{
    //open file browser to select input SRIM file path
    FileBrowser browser;
    browser.exec();
    path_vac=browser.on_buttonBox_accepted();
    ui->lineEdit_vac->setText(path_vac);
    plot_vac();
}


void Radhard_dialog::setupVac(QCustomPlot *potPlot)
{
    potPlot->addGraph();
    potPlot->graph(0)->setPen(QPen(Qt::green));
    potPlot->graph(0)->setBrush(QBrush(QColor(0, 250, 250)));
    potPlot->graph(0)->setAntialiasedFill(false);
    potPlot->graph(0)->setPen(QPen(Qt::blue));
    QVector<double> x_vac_um, y_vac_um;
    x_vac_um.resize(x_vac.size());
    y_vac_um.resize(y_vac.size());

   //rescale to convert in micrometers
    for(int i=0; i<x_vac.size(); i++)
    {
        x_vac_um[i]=x_vac[i]; //units: um
        y_vac_um[i]=y_vac[i]/100; //units: vac/cm
    }

  potPlot->xAxis->setVisible(true);
  potPlot->xAxis2->setVisible(false);
  potPlot->xAxis2->setTickLabels(true);
  potPlot->yAxis2->setVisible(true);
  potPlot->yAxis2->setTickLabels(false);
  potPlot->graph(0)->setData(x_vac_um, y_vac_um);
  potPlot->xAxis->setLabel("Position (um)");
  potPlot->yAxis->setLabel("Vacancy dens. (1/cm)");
  potPlot->graph(0)->rescaleAxes(true);
  potPlot->xAxis->setRange(0.0,x_vac[x_vac.size()-1]);

  //set maximum value for y axis plotting
  double max_vac=0;

  for(int i=0; i<y_vac_um.size(); i++)
  {
      if(max_vac<y_vac_um[i]) max_vac=y_vac_um[i];
  }
  potPlot->yAxis->setRange(0.0,max_vac);
}




void Radhard_dialog::update_values()
{
    //store updated values from user edit
    fluence = ui->lineEdit_fluence->text().toDouble(&val1);
    sigmap = ui->lineEdit_sigma_p-> text().toDouble(&val2);
    sigman = ui->lineEdit_sigma_n-> text().toDouble(&val3);
    ptherm = ui->lineEdit_vth_p-> text().toDouble(&val4);
    ntherm = ui->lineEdit_vth_n-> text().toDouble(&val5);
    radhard_p = ui->doubleSpinBox_p->value();
    radhard_n = ui->doubleSpinBox_n->value();
}


void Radhard_dialog::on_radioButton_yes_clicked()
{
    //enable objects interaction if clicked
    ui->lineEdit_fluence->setEnabled(true);
    ui->lineEdit_sigma_n->setEnabled(true);
    ui->lineEdit_sigma_p->setEnabled(true);
    ui->lineEdit_vac->setEnabled(true);
    ui->lineEdit_vth_n->setEnabled(true);
    ui->lineEdit_vth_p->setEnabled(true);
    ui->pushButton_vacBrowse->setEnabled(true);
    ui->doubleSpinBox_n->setEnabled(true);
    ui->doubleSpinBox_p->setEnabled(true);
    radiation_control=1;
    ui->vac_plot->setVisible(true);
}

void Radhard_dialog::on_radioButton_no_clicked()
{
    //disable objects interaction if clicked
    ui->lineEdit_fluence->setEnabled(false);
    ui->lineEdit_sigma_n->setEnabled(false);
    ui->lineEdit_sigma_p->setEnabled(false);
    ui->lineEdit_vac->setEnabled(false);
    ui->lineEdit_vth_n->setEnabled(false);
    ui->lineEdit_vth_p->setEnabled(false);
    ui->pushButton_vacBrowse->setEnabled(false);
    ui->doubleSpinBox_n->setEnabled(false);
    ui->doubleSpinBox_p->setEnabled(false);
    control_vac=0;
    ui->vac_plot->setVisible(false);
}

void Radhard_dialog::on_pushButton_ok_clicked()
{
    //check for control variables. if OK, set radiation_control as selected by user, close window and set control_window to 0.
    //if not, control_window=1
    if(control_vac==0 && ui->radioButton_yes->isChecked())
    {
        if(val1==true && val2==true && val3==true && val4==true && val5==true)
        {
        control_window=0;
        radiation_control=1;
        }
    }

    else if(control_vac==0 && ui->radioButton_no->isChecked())
    {
        control_window=0;
        radiation_control=0;
    }
    else
    {
        control_window=1;
    }
}


void Radhard_dialog::on_pushButton_cancel_clicked()
{
    //set control_window to 1: mainwindow will discard changes
    control_window=1;
}

void Radhard_dialog::setup_vac_plot_first()
{
    //import vacancy profile from path previously stored by maindow

    x_vac.resize(100);
    y_vac.resize(100);
    qDebug() << "settato lunghezza array a 100";
    control_vac=0;
    QFile file_vac(path_vac);
    QTextStream its_vac(&file_vac);
    QString line_vac;
    if (!file_vac.open(QIODevice::ReadOnly))
        {
        control_vac=1;
        }

    qDebug() << "aperto il file di lettura";

    if(control_vac==0)
        {
       /* for(int l=0; l<28; l++)
            {
            line_vac = its_vac.readLine();
            }

        for(int l=0; l<100; l++)
            {
            line_vac = its_vac.readLine();
            line_vac.replace(",",".");
            QStringList list_vac=line_vac.split(" ",QString::SkipEmptyParts);
            x_vac[l]=list_vac[0].toDouble()*1e-4;            //units: um
            y_vac[l]=list_vac[2].toDouble()*1e10;            //units: vac/m
            }

        file_vac.close();*/


        int l=0;

        while(!its_vac.atEnd())
        {


        line_vac = its_vac.readLine();
        line_vac.replace(",",".");
        line_vac.replace("\t", "   ");
        QStringList list_vac=line_vac.split(" ",QString::SkipEmptyParts);

        if(list_vac.size()>0)
        {
        bool validate1, validate2;

        list_vac.first().toDouble(&validate1);
        list_vac.last().toDouble(&validate2);

        if (validate1 == true && validate2 ==true && list_vac.size()>1)
        {
        x_vac[l]=list_vac.first().toDouble()*1e-4-dead_layer;  //inserito già in micrometri
        y_vac[l]=list_vac.last().toDouble()*1e10;            //udm: vac/m
        l++;
        }

        }
        }


    file_vac.close();

        setupVac(ui->vac_plot);
        ui->vac_plot->replot();
    }
}
