/*
| IBIC Simulation Tool
| Copyright (C) 2012-2013 Jacopo Forneris
| http://www.dfs.unito.it/solid/IST.html

This file is part of IBIC simulation tool.

    IBIC simulation tool is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    IBIC simulation tool is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with IBIC Simulation Tool.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef RADHARD_DIALOG_H
#define RADHARD_DIALOG_H

#include <QDialog>
#include <QObject>
#include "./qcustomplot.h"
#include "mainwindow.h"

namespace Ui {
class Radhard_dialog;
}

class Radhard_dialog : public QDialog
{
    Q_OBJECT
    
public:
    explicit Radhard_dialog(QWidget *parent = 0);
    ~Radhard_dialog();
    
    double radhard_p, radhard_n, fluence, sigmap, sigman, ptherm, ntherm, dead_layer; // copy of mainwindow variables for local user editing
    QString path_vac;   // path for SRIM file import
    QVector<double> x_vac, y_vac; // vectors for SRIM file import

    int control_vac; // control variable for vacancy SRIM profile import. 0: OK, 1: file doesn't exist
    int radiation_control; //control variable for radiation damage user selection. 1: consider radiation damage; 0: radiation damage discarded
    int control_window; //exit status for mainwindow: 0:everything OK, 1: error exit
    bool val1,val2,val3,val4,val5; //control variables: check all input data is correct to enable OK button

private slots:
    void on_pushButton_vacBrowse_clicked(); // open filesystem to select import file
    void setupVac(QCustomPlot *potPlot);    // setup vacancy profile plot
    void update_values();                   // update input values when edited by user
    void on_radioButton_yes_clicked();      // consider radiation damage in simulation
    void on_radioButton_no_clicked();       // discard radiation damage in simulation
    void on_pushButton_ok_clicked();        // save input and close window
    void on_pushButton_cancel_clicked();    //discard input (keep previous values) and close window
    void setup_vac_plot_first();            //read from file, launch setupVac() and plot vacancy profile
    void plot_vac();                        //read from file, launch setupVac()and plot vacancy profile

private:
    Ui::Radhard_dialog *ui;
};

#endif // RADHARD_DIALOG_H
